/*------------------------------------------------------------------------------*
 * File Name: GetNBox2.h														*
 * Creation: ML 2/14/2006														*
 * Purpose: Origin C for GetNBox dlgs that work with DynaControl				*
 * Copyright (c) OriginLab Corp. 2006, 2007, 2008, 2009, 2010, 2011, 2012		*
 * All Rights Reserved		 													*
 * 																				*
 * Modification Log:															*
 *	ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg									*
 *	YuI 04/17/06 GLOBAL_EVENT_HANDLER_NEEDS_TO_BE_INVOKED						*
 *	TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON									*
 *	 TD 6-30-06 QA70-8792  ALLOW_RESIZING										*
 *	CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS									*
 *	Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG		*
 *	CPY 5/28/2007 QA70-9839 GETNBOX_BETTER_POSITION_CNTRL						*
 *	Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM							*
 *	YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION				*
 *	Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON								*
 *  Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN			*
 *	Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
 *------------------------------------------------------------------------------*/

#ifndef _GETN_DLG_H
#define _GETN_DLG_H

class DynaBoxDlg : public DynaDlg
{
private:
	
	PAPPLY_FUNC m_pApplyFunc;
	/// TD 5-2-06 MOVE_TO_BASE_CLASS
	//PEVENT_FUNC m_pEventFunc;
	///  end TD 5-2-06 MOVE_TO_BASE_CLASS
	bool		m_bUseTryForApply;//CPY 4/23/03 v7.0568 OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE

	bool		m_bApply1stTime;
	string		m_strTitle;
	//
	string		m_strClassName;
	
	string		m_strMaxHeightWidth;	///DG SUPPORT_MAX_HEIGHT_WIDTH_SETTING : separate with '|'
	
	////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION
	string		m_strbnOKText;
	string		m_strbnApplyText;
	//----------- CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
	//bool		m_bApplyBtnExit;
	int			m_nButtonExitEventID;
	//-----------
	////----- END MORE_ON_ASCII_OPTION
	
	//RangeControl m_dataRange;
	//--- CPY 7/1/06 REMOVE_SHIFT_SHOW_CHECK
	// the following is not used any more
	/*
	Button		m_chkShiftShow;
	int			m_nShiftShowCheck;
	Button		m_chkAutoUpdate;
	*/
	//---
	int			m_nDlgID;
	
	//TreeEditControl		m_treeEditCntrl;
	
	Button		m_chkAdvanced; //--- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
	bool		m_bAllowResizing; //--- CPY 6-30-06 QA70-8792 GETN_RESIZING_FROM_ATTRIBUTE
	
	/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
	//bool		m_bShowApplyGetNEvent;	///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
	bool		m_bShowApply;
	///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
	
	bool		m_bRepeatingApply; ///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
public:
	
private:
	//--- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
	//bool		isShowAdvanced();
	bool		isShowAdvanced(TreeNode &tr = NULL);///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE
	//---
	
	bool 		isApplyButtonShow(); /// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN

public:
	///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
	//DynaBoxDlg(int nID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PEVENT_GETN pGetNEvent, PAPPLY_FUNC pfn = NULL, PEVENT_FUNC pEvtFn = NULL);
	DynaBoxDlg(int nID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PEVENT_GETN pGetNEvent, PAPPLY_FUNC pfn = NULL, PEVENT_FUNC pEvtFn = NULL, bool bShowApply = false);
	///End GETN_BOX_ADD_APPLY_BUTTON
	// TD 6-30-06 QA70-8792  ALLOW_RESIZING
	void 	AllowResizing(BOOL bResizing = TRUE);
	// end ALLOW_RESIZING
	int 	DoModalEx(HWND hWndParent = NULL);
	int 	CreateEx(HWND hWndParent = NULL);
	BOOL 	OnInitDialog();
	BOOL	OnReady();
	BOOL 	OnDestroy(void);
	BOOL 	OnDlgResize(int nType, int cx, int cy);//--- CPY 6-30-06 QA70-8792 GETN_RESIZING_FROM_ATTRIBUTE
	//--- CPY 7/5/06 QA70-8798 ON_OK_EVENT_TO_ALLOW_XF_HANDLING
	BOOL	OnOK() {return OnOKEvent();}   
	//---
	#if _OC_VER >= 0x0800
	BOOL	OnShowAdvancedCheck(Control ctrl); //---- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
//	BOOL	OnSelectionChange();
//	BOOL	OnSelectionTrack();
	
	/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
	///// YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS
	//BOOL	OnInteractiveDataRange(Control ctrl);
	//BOOL	OnInteractiveXYDataRange(Control ctrl);
	//BOOL	OnInteractivePopUp(Control ctrl);
	///// end VECTORIAL_NUMERIC_FUNCTIONS	
	/// end NEW_TREECONTROL_FOR_GetNBoxDlg
	
	#endif //if _OC_VER >= 0x0800

	BOOL 	OnApplyButton(Control cntrl);
	BOOL 	OnUndoButton(Control cntrl); ///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	BOOL 	OnKey(BOOL bRollingUp);
	/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
	//void 	OnAfterCollapse(Control cntrl, int nRow, short nState);
	//BOOL 	OnReconstructGrid(UINT wParam, UINT lParam);
	//void	OnComboCloseUp(Control cntrl, int nRow, int nCol, BOOL* pFinishEdit);	///DG FIT_SIZE_WHEN_LIST_CHANGED
	/// end NEW_TREECONTROL_FOR_GetNBoxDlg
	///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	/// move to DynaDlg.h
	//BOOL	OnAfterExpandCollapse(uint wParam, uint lParam);
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	
//	BOOL OnInternalResize(uint wParam, uint lParam);
	
	/// TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON
//	BOOL	OnGenericControlMsg(TreeNode &node, uint nCode);
	/// end EDITBOX_WITH_BUTTON
	///Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG	
	//virtual
	string GetDlgTitle();
	///end MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
	
	////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION 
	void SetButtonText(LPCSTR lpcszOKText, LPCSTR lpcszApplyText);
	//----------- CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
	//BOOL IsApplyExit() { return m_bApplyBtnExit; }
	bool CheckSpecialExit(int& nRet);
	//-----------
	////----- END MORE_ON_ASCII_OPTION 

	DECLARE_MESSAGE_MAP
protected:
	
	BOOL OnRestoreSize(DWORD dwSizeInfo); //----- CPY 5/28/2007 QA70-9839 GETNBOX_BETTER_POSITION_CNTRL

	/// YuI 04/17/06 GLOBAL_EVENT_HANDLER_NEEDS_TO_BE_INVOKED
	virtual void InvokeGlobalEventOnInitDialog();
	/// end GLOBAL_EVENT_HANDLER_NEEDS_TO_BE_INVOKED
	
	/// CPY Iris 7/20/06 v8.0447 SEPRATE_INIT_AND_THEME_EVENT
	virtual void InvokeGlobalEventOnThemeChange();
	///end SEPRATE_INIT_AND_THEME_EVENT
	
	///sandy 2007-4-2 MOVE_GRAPH_OBJECT_EVENT_TO_BASE_CLASS
	/// Iris 12/28/2006 v8.0533 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	//BOOL 	InvokeGlobalEventOnGraphObjectChange(uint wParam, uint lParam);
	///end CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	///end MOVE_GRAPH_OBJECT_EVENT_TO_BASE_CLASS

	//virtual 
	void ResizeDlgControls();//CPY 10/29/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT	
	///Joseph 02/25/06 DO_NOT_ENABLE_BUTTON_ON_SOME_EVENTS
	////---- CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
	////virtual 
	//void OnEnableButtons(DWORD dwEnable);// OK and Apply buttons
	////----
	void OnEnableButtons(DWORD dwEnable,int nEventID = GETNE_ON_INIT);// OK and Apply buttons
	///End DO_NOT_ENABLE_BUTTON_ON_SOME_EVENTS

	//---- CPY 8/28/06 IMPASCI_XF_SHOW_NEED_TO_UPDATE_DLG_SIZE_WHEN_TREE_CHANGED
	//virtual
	void OnTreeReinit() {resizeDlgToFit();}
	//----
	
	//after change value, check the errmsg, for operation dialog
	void OnAfterValueChange(int nRow, int nCol);///Joseph	12/07/06	OPERATION_DIALOG_ADD_MSGBOX
		
	void OnInitChangeButtonText(LPCSTR lpcszText);
	///End GETN_BOX_ADD_APPLY_BUTTON
	//-------- CPY 2/24/2007 ADDING_CUSTOM_BUTTON4
	/////Joseph 02/05/07 DYNABOX_DLG_NEED_MORE_BTNS
	//BOOL OnClickCustomButtom1(Control ctrl);
	//BOOL OnClickCustomButtom2(Control ctrl);
	//BOOL OnClickCustomButtom3(Control ctrl);
	/////End DYNABOX_DLG_NEED_MORE_BTNS
	//virtual 
	BOOL OnClickCustomButton(int nID);
	//-------- end ADDING_CUSTOM_BUTTON4
//----------- CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
	/////Joseph 02/14/07 SUPPORT_MORE_SPECAIL_EVENT
	//virtual bool IsSpecialEvent(int nEventID);
	//void OnSpecialButtons(int nEventID, const string& strAux);
	/////Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
	//void OnCustomButtonCloseDialog(int nEventID, int nReturnValue);
	/////End SUPPORT_MORE_SPECAIL_EVENT
	//virtual
	bool CheckCustomBottonEvents(int nEventID, int nEventRet, const string& strAux);
//-----------

	/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
	///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
	//virtual bool	CheckApplyButtonEvent(TreeNode& trGetN, int nEventID, int nEventReturn);
	virtual bool	CheckApplyButtonEvent(TreeNode& trGetN, int nEventID, int nEventReturn, LPCSTR lpcszAux, int* pnApplyReturn = NULL);
	///---END QA80-11156 XF_PANEL_APPLY_BUTTON
	/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION

//private:
	//------ CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	//void 	trimThemeFileForDisplay(string& strFilename);
	//bool 	loadThemeFilesToCombo(const TreeNode& trGUI);
	//----- CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH
	//void	updateSaveButton(const string& strSelTheme);
	///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE
	//void	updateThemeDescription(TreeNode& trGUI, bool bEditToTree = true);
	//string	updateThemeDescription(TreeNode& trGUI, bool bEditToTree = true);
	///End	GETN_DLG_ADVANCED_CHECK_SAVE
	//----
	int		getShiftShowStatus();
	void 	updateShiftShowStatus();
	bool 	shiftShow(bool bGet = true, bool bVal = false);
	void	saveDefaultGUI();
	// TD 5-2-06
	//PEVENT_FUNC 	getEventHandler();
	// end TD 5-2-06
	PAPPLY_FUNC 	getApplyFunction();
	void 	enableButton(uint nBtnID, bool bEnable);
	void 	resizeDlgToFit(int cx = 0, int cy = 0);
	void 	resizeDialog(uint* pIntIDs, int cx = 0, int cy = 0);
	DWORD 	preCreateGetNBoxDlg(HWND hWndParent);
	
	bool	isShowAdvancedBox(TreeNode& tr); //--- Iris 11/10/06 HIDE_SHOWADVAN_BOX
};

#endif //_GETN_DLG_H
	
